% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/MapSchedule.R
\docType{methods}
\name{schedule}
\alias{schedule}
\alias{schedule,GeneratedCode-method}
\alias{schedule,DependGraph-method}
\title{Schedule Dependency Graph}
\usage{
schedule(graph, maxWorker = 2L, ...)

\S4method{schedule}{GeneratedCode}(graph, maxWorker = 2L, ...)

\S4method{schedule}{DependGraph}(graph)
}
\arguments{
\item{graph}{object of class \linkS4class{DependGraph}}

\item{maxWorker}{integer maximum number of parallel workers}

\item{...}{additional arguments to methods}
}
\description{
Creates the schedule for a dependency graph. The schedule is the
assignment of the expressions to different processors at different
times. There are many possible scheduling algorithms. The default is
\code{\link{mapSchedule}}, which does
simple map parallelism using R's apply family of functions.
}
\references{
See \emph{Task Scheduling for Parallel Systems}, Sinnen, O.
for a thorough treatment of what it means to have a valid schedule.
}
