% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MapSchedule.R
\name{mapSchedule}
\alias{mapSchedule}
\title{Data Parallel Scheduler}
\usage{
mapSchedule(graph)
}
\arguments{
\item{graph}{\linkS4class{DependGraph}}
}
\description{
This function
detects parallelism through the use of top level calls to R's
apply family of functions and through analysis of \code{for} loops.
Currently supported apply style functions include
\code{\link[base]{lapply}} and \code{\link[base]{mapply}}. It doesn't
parallelize all for loops that can be parallelized, but it does do the
common ones listed in the example.
}
\details{
Consider using this if:

\itemize{
 \item \code{code} is slow
 \item \code{code} uses for loops or one of the apply functions mentioned above
 \item You have access to machine with multiple cores that supports
     \code{\link[parallel]{makeForkCluster}} (Any UNIX variant should work,
     ie. Mac)
 \item You're unfamiliar with parallel programming in R
}

Don't use this if:

\itemize{
 \item \code{code} is fast enough for your application
 \item \code{code} is already parallel, either explicitly with a package
     such as parallel, or implicitly, say through a multi threaded BLAS
 \item You need maximum performance at all costs. In this case you need
     to carefully profile and interface appropriately with a high
     performance library.
}

Currently this function support \code{for} loops that update 0 or 1
global variables. For those that update a single variable the update
must be on the last line of the loop body, so the for loop should have
the following form:

\code{
for(i in ...){
  ... 
  x[i] <- ...
}
}

If the last line doesn't update the variable then it's not clear that
the loop can be parallelized.

Road map of features to implement:

\itemize{
 \item Prevent from parallelizing calls that are themselves in the body
 of a loop.
}
}
\examples{

# Each iteration of the for loop writes to a different file- good!
# If they write to the same file this will break.
pfile <- makeParallel(parse(text = "
     fnames <- paste0(1:10, '.txt')
     for(f in fname){
         writeLines('testing...', f)
     }"))

# A couple examples in one script
serial_code <- parse(text = "
     x1 <- lapply(1:10, exp)
     n <- 10
     x2 <- rep(NA, n)
     for(i in seq(n)) x2[[i]] <- exp(i + 1)
")

p <- makeParallel(serial_code)

eval(serial_code)
x1
x2
rm(x1, x2)

# x1 and x2 should now be back and the same as they were for serial
eval(writeCode(p))
x1
x2
}
