% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bucher.R
\name{find_SE_from_CI}
\alias{find_SE_from_CI}
\title{Calculate standard error from the reported confidence interval.}
\usage{
find_SE_from_CI(CI_lower = NULL, CI_upper = NULL, CI_perc = 0.95, log = TRUE)
}
\arguments{
\item{CI_lower}{Reported lower percentile value of the
treatment effect}

\item{CI_upper}{Reported upper percentile value of the
treatment effect}

\item{CI_perc}{Percentage of confidence interval reported}

\item{log}{Whether the confidence interval should be logged.
For relative treatment effect, log should be applied because
estimated log treatment effect is approximately normally distributed.}
}
\value{
Standard error of log relative treatment effect if \code{'log'}
is true and standard error of the treatment effect if \code{'log'}
is false
}
\description{
Comparator studies often only report confidence interval of the
treatment effects. This function calculates standard error of the
treatment effect given the reported confidence interval.
For relative treatment effect (i.e. hazard ratio, odds ratio, and
risk ratio), the function would log the confidence interval.
For risk difference and mean difference,
we do not log the confidence interval.
The option to log the confidence interval is controlled
by \code{'log'} parameter.
}
\examples{
find_SE_from_CI(CI_lower = 0.55, CI_upper = 0.90, CI_perc = 0.95)
}
