% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edges.R
\name{edges}
\alias{edges}
\alias{image_edge}
\alias{image_canny}
\alias{image_hough_draw}
\alias{image_hough_txt}
\title{Edge / Line Detection}
\usage{
image_edge(image, radius = 1)

image_canny(image, geometry = "0x1+10\%+30\%")

image_hough_draw(
  image,
  geometry = NULL,
  color = "red",
  bg = "transparent",
  size = 3,
  overlay = FALSE
)

image_hough_txt(image, geometry = NULL, format = c("mvg", "svg"))
}
\arguments{
\item{image}{magick image object returned by \code{\link[=image_read]{image_read()}} or \code{\link[=image_graph]{image_graph()}}}

\item{radius}{edge size in pixels}

\item{geometry}{geometry string, see details.}

\item{color}{a valid \href{https://www.imagemagick.org/Magick++/Color.html}{color string} such as
\code{"navyblue"} or \code{"#000080"}. Use \code{"none"} for transparency.}

\item{bg}{background color}

\item{size}{size in points to draw the line}

\item{overlay}{composite the drawing atop the input image. Only for \code{bg = 'transparent'}.}

\item{format}{output format of the text, either \code{svg} or \code{mvg}}
}
\description{
Best results are obtained by finding edges with \code{\link[=image_canny]{image_canny()}} and
then performing Hough-line detection on the edge image.
}
\details{
For Hough-line detection, the geometry format is \verb{\{W\}x\{H\}+\{threshold\}}
defining the size and threshold of the filter used to find 'peaks' in
the intermediate search image. For canny edge detection the format is
\verb{\{radius\}x\{sigma\}+\{lower\%\}+\{upper\%\}}. More details and examples are
available at the \href{https://www.imagemagick.org/Usage/transform/#hough}{imagemagick website}.
}
\examples{
if(magick_config()$version > "6.8.9"){
shape <- demo_image("shape_rectangle.gif")
rectangle <- image_canny(shape)
rectangle \%>\% image_hough_draw('5x5+20')
rectangle \%>\% image_hough_txt(format = 'svg') \%>\% cat()
}
}
\seealso{
Other image: 
\code{\link{_index_}},
\code{\link{analysis}},
\code{\link{animation}},
\code{\link{attributes}()},
\code{\link{color}},
\code{\link{composite}},
\code{\link{defines}},
\code{\link{device}},
\code{\link{editing}},
\code{\link{effects}()},
\code{\link{fx}},
\code{\link{geometry}},
\code{\link{morphology}},
\code{\link{ocr}},
\code{\link{options}()},
\code{\link{painting}},
\code{\link{segmentation}},
\code{\link{transform}()},
\code{\link{video}}
}
\concept{image}
