% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot.magioutput}
\alias{plot.magioutput}
\title{Plot trajectories from \code{magioutput} object}
\usage{
\method{plot}{magioutput}(
  x,
  obs = TRUE,
  ci = TRUE,
  comp.names,
  lower = 0.025,
  upper = 0.975,
  nplotcol = 3,
  ...
)
}
\arguments{
\item{x}{a \code{magioutput} object.}

\item{obs}{logical; if true, points will be added on the plots for the observations.}

\item{ci}{logical; if true, credible bands will be added to the plots.}

\item{comp.names}{vector of system component names. If provided, should be the same length as the number of system components in \eqn{X}.}

\item{lower}{the lower quantile of the credible band, default is 0.025. Only used if \code{ci = TRUE}.}

\item{upper}{the upper quantile of the credible band, default is 0.975. Only used if \code{ci = TRUE}.}

\item{nplotcol}{the number of subplots per row.}

\item{...}{additional arguments to \code{plot}.}
}
\description{
Plots the inferred trajectories from the output of \code{MagiSolver}
}
\details{
Plots inferred trajectories (posterior means) and credible bands from the MCMC samples, one subplot for each system component.
By default, \code{lower = 0.025} and \code{upper = 0.975} produces a central 95\% credible band when \code{ci = TRUE}.
Adding the observed data points (\code{obs = TRUE}) can provide a visual assessment of the inferred trajectories.
}
\examples{
# Set up odeModel list for the Fitzhugh-Nagumo equations
fnmodel <- list(
  fOde = fnmodelODE,
  fOdeDx = fnmodelDx,
  fOdeDtheta = fnmodelDtheta,
  thetaLowerBound = c(0, 0, 0),
  thetaUpperBound = c(Inf, Inf, Inf)
)

# Example FN data
data(FNdat)
y <- setDiscretization(FNdat, by = 0.25)

# Create magioutput from a short MagiSolver run (demo only, more iterations needed for convergence)
result <- MagiSolver(y, fnmodel, control = list(nstepsHmc = 20, niterHmc = 500)) 

plot(result, comp.names = c("V", "R"), xlab = "Time", ylab = "Level")

}
