% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_pipeline.R
\name{create_pipeline}
\alias{create_pipeline}
\title{Create a new pipeline in a pipelines directory}
\usage{
create_pipeline(
  pipe_name,
  pipeline_dir = "pipelines",
  frequency = "1 day",
  start_time = Sys.Date(),
  tz = "UTC",
  log_level = "INFO",
  quiet = FALSE,
  open = interactive(),
  overwrite = FALSE
)
}
\arguments{
\item{pipe_name}{name of the pipeline and function}

\item{pipeline_dir}{directory containing the pipeline scripts}

\item{frequency}{how often the pipeline should run (e.g., 1 day, daily, 3 hours, 4 months). Fills in maestroFrequency tag}

\item{start_time}{start time of the pipeline schedule. Fills in maestroStartTime tag}

\item{tz}{timezone that pipeline will be scheduled in. Fills in maestroTz tag}

\item{log_level}{log level for the pipeline (e.g., INFO, WARN, ERROR). Fills in maestroLogLevel tag}

\item{quiet}{whether to silence messages in the console (default = \code{FALSE})}

\item{open}{whether or not to open the script upon creation}

\item{overwrite}{whether or not to overwrite an existing pipeline of the same name and location.}
}
\value{
invisible
}
\description{
Allows the creation of new pipelines (R scripts) and fills in the maestro tags as specified.
}
\examples{
if (interactive()) {
  pipeline_dir <- tempdir()
  create_pipeline(
    "extract_data",
    pipeline_dir = pipeline_dir,
    frequency = "1 hour",
    open = FALSE,
    quiet = TRUE,
    overwrite = TRUE
  )

  create_pipeline(
    "new_job",
    pipeline_dir = pipeline_dir,
    frequency = "20 minutes",
    start_time = as.POSIXct("2024-06-21 12:20:00"),
    log_level = "ERROR",
    open = FALSE,
    quiet = TRUE,
    overwrite = TRUE
  )
}
}
