% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-unit_checks.R
\name{check_dataset_categories}
\alias{check_dataset_categories}
\title{Assess a data dictionary and associated dataset for category differences}
\usage{
check_dataset_categories(dataset, data_dict = NULL)
}
\arguments{
\item{dataset}{A dataset object.}

\item{data_dict}{A list of data frame(s) representing metadata to be evaluated.}
}
\value{
A data frame providing categorical values which differ between dataset and
their data dictionary.
}
\description{
Generates a data frame report of any categorical value options (the
combination of 'variable' and 'name' in 'Categories') in a data dictionary
that are not in the associated dataset and any categorical variable values
in a dataset that are not declared in the associated data dictionary.
This report can be used to help assess data structure, presence of fields,
coherence across elements, and taxonomy or data dictionary formats.
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.

A dataset is a data table containing variables. A dataset object is a
data frame and can be associated with a data dictionary. If no
data dictionary is provided with a dataset, a minimum workable
data dictionary will be generated as needed within relevant functions.
Identifier variable(s) for indexing can be specified by the user.
The id values must be non-missing and will be used in functions that
require it. If no identifier variable is specified, indexing is
handled automatically by the function.
}
\examples{
{

# use madshapR_DEMO provided by the package

data_dict <- madshapR_DEMO$`data_dict_TOKYO - errors with data`
dataset      <- madshapR_DEMO$`dataset_TOKYO - errors with data`
check_dataset_categories(dataset, data_dict)

}

}
