% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-catalogue_functions.R
\name{is_taxonomy}
\alias{is_taxonomy}
\title{Test if an object is a valid taxonomy}
\usage{
is_taxonomy(object)
}
\arguments{
\item{object}{A potential taxonomy to be evaluated.}
}
\value{
A logical.
}
\description{
Confirms whether the input object is a valid taxonomy. This function mainly
helps validate input within other functions of the  package but could be
used to check if a taxonomy is valid.
}
\details{
A taxonomy is classification scheme that can be defined for variable
attributes. If defined, a taxonomy must be a data frame-like object. It must
be compatible with (and is generally extracted from) an Opal environment. To
work with certain functions, a valid taxonomy must contain at least the
columns 'taxonomy', 'vocabulary', and 'terms'. In addition, the taxonomy
may follow Maelstrom research taxonomy, and its content can be evaluated
accordingly, such as naming convention restriction, tagging elements,
or scales, which are specific to Maelstrom Research. In this particular
case, the tibble must also contain 'vocabulary_short', 'taxonomy_scale',
'vocabulary_scale' and 'term_scale' to work with some specific functions.
}
\examples{
{

# use DEMO_files provided by the package

is_taxonomy(DEMO_files$taxonomy_PARIS)
is_taxonomy(DEMO_files$taxonomy_opal_mlstr)
is_taxonomy(iris)

}

}
