% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-dataset_functions.R
\name{as_dataset}
\alias{as_dataset}
\title{Validate and coerce an object to dataset format}
\usage{
as_dataset(object, col_id = NULL)
}
\arguments{
\item{object}{A potential dataset to be coerced.}

\item{col_id}{A character string specifying the name(s) of the column(s)
which refer to key identifier of the dataset. The column(s) can be named
or indicated by position.}
}
\value{
A tibble identifying a dataset.
}
\description{
Confirms that the input object is a valid dataset and returns it as a dataset
with the appropriate 'madshapR::class' attribute. This function mainly helps
validate inputs within other functions of the package but could be used to
check if a dataset is valid.
}
\details{
A dataset must be a data frame-like object and can be associated with a
data dictionary. If no data dictionary is provided, a minimum workable
data dictionary will be generated as needed by relevant functions.
An identifier \code{id} column for sorting can be specified by the user. If
specified, the \code{id} values must be non-missing and will be used in functions
that require it. If no identifier column is specified, indexing is handled
automatically by the function.
}
\examples{
{

# use DEMO_files provided by the package

###### Example 1: a dataset can have an id column(s) which is specified as
# an attribute. 
dataset <- as_dataset(DEMO_files$dataset_MELBOURNE_1, col_id = "id")

###### Example 2: any data frame (or tibble) can be a dataset by definition.
as_dataset(iris, col_id = "Species")
}

}
