% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-dictionaries_functions.R
\name{data_dict_group_split}
\alias{data_dict_group_split}
\title{Split grouped data dictionaries into a named list}
\usage{
data_dict_group_split(data_dict, ...)
}
\arguments{
\item{data_dict}{A list of tibble(s) representing meta data to be
transformed.}

\item{...}{Column in the data dictionary to split it by. If not provided, the
splitting will be done on the grouping element of a grouped data dictionary.}
}
\value{
A list of tibble(s) identifying a list of workable data dictionary structure.
}
\description{
Divides data dictionary element(s) into the groups defined by the query.
This function divides both the 'Variables' and 'Categories' elements (if
the group exists under the same definition in in both) into a list of
data dictionaries, each with the rows of the associated group and all the
original columns, including grouping variables. This function is analogous
to running \code{\link[dplyr:group_by]{dplyr::group_by()}} and \code{\link[dplyr:group_split]{dplyr::group_split()}}. Each element is
named using the group values. \code{\link[=data_dict_list_nest]{data_dict_list_nest()}} reverses the effect.
}
\details{
A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.
}
\examples{
{

# use DEMO_files provided by the package
library(dplyr)

# Create a list of data dictionaries where the column 'table' is added to 
# refer to the associated dataset. The object created is not a 
# data dictionary per say, but can be used as a structure which can be 
# shaped into a data dictionary.

data_dict_list <- DEMO_files[
    c('dd_MELBOURNE_1_format_maelstrom',
      'dd_MELBOURNE_2_format_maelstrom')] \%>\% 
    data_dict_list_nest(name_group = 'table')
 
 data_dict_group_split(data_dict_list,col = "table")
 
}

}
\seealso{
\code{\link[dplyr:group_by]{dplyr::group_by()}}, \code{\link[dplyr:group_split]{dplyr::group_split()}} ,
\code{\link[=data_dict_group_by]{data_dict_group_by()}}, \code{\link[=data_dict_list_nest]{data_dict_list_nest()}}
}
