% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OM.MA.r
\name{OM.MA}
\alias{OM.MA}
\title{Calculate model probabilities for the outcome models using a pseudo-MC3 algorithm}
\usage{
OM.MA(Y, X, U, W = NULL, M = 1000, alpha = NULL, binary = F)
}
\arguments{
\item{Y}{vector of the outcome}

\item{X}{vector of the treatment (0/1)}

\item{U}{matrix of covariates to be considered for inclusion/exclusion}

\item{W}{matrix of covariates that will be included in all models (optional)}

\item{M}{the number of MCMC iteration}

\item{alpha}{vector of inclusion indicators (which columns of U) to start MCMC algorithm (optional)}

\item{binary}{indicator if the outcome is binary (optional)}
}
\value{
A list. The list contains the following named components:
\item{dict}{a list that contains the BIC, predicted values, and estimated treatment effect from each outcome model}
\item{alpha}{the last model visited by the algorithm}
\item{out.table}{a matrix that contains the BIC and estimated treatment effect from each outcome model}
}
\description{
This function uses a pseudo-MC3 algorithm to search the outcome model space.
}

