% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec.r
\docType{methods}
\name{vec}
\alias{vec}
\alias{vec,madness-method}
\alias{vec,array-method}
\alias{vech}
\alias{vech,array-method}
\alias{vech,madness-method}
\alias{ivech}
\alias{ivech,ANY-method}
\alias{ivech,madness-method}
\title{vectorize a multidimensional array.}
\usage{
vec(x)

\S4method{vec}{madness}(x)

\S4method{vec}{array}(x)

vech(x, k = 0)

\S4method{vech}{array}(x, k = 0)

\S4method{vech}{madness}(x, k = 0)

ivech(x, k = 0, symmetric = FALSE)

\S4method{ivech}{ANY}(x, k = 0, symmetric = FALSE)

\S4method{ivech}{madness}(x, k = 0, symmetric = FALSE)
}
\arguments{
\item{x}{a \code{madness} object or multidimensional array or matrix.}

\item{k}{the diagonal from which to subselect.}

\item{symmetric}{logical whether to put the array on the antidiagonal
as well. Will throw an error if \code{k > 0}.}
}
\value{
a \code{madness} object or an array, of the vectorized array
or the subselected part. For the inverse operations, promotes to a
\code{madness} of a matrix, or a matrix.
}
\description{
Turn a multidimensional array into a (column) vector. 
Turn a (typically symmetric) matrix into a (column) vector of
the lower triangular part. Or reverse these
operations.
}
\examples{
y <- matrix(rnorm(16),ncol=4)
sy <- y + t(y)
vy <- vec(sy)
vmy <- vec(madness(sy))
vhy <- vech(sy)
vmhy <- vech(madness(sy))

ivech(c(1,2,3))
ivech(c(1,2,3),-1)
ivech(c(1,2,3),-1,symmetric=TRUE)
ivech(c(1,2,3,4,5,6,7,8),1)
}
\seealso{
\code{\link{reshapes}}, in particular \code{tril}.
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
