% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivariate-copula.r
\name{copula2d.cond}
\alias{copula2d.cond}
\alias{dcopula.cond}
\alias{pcopula.cond}
\alias{qcopula.cond}
\alias{rcopula.cond}
\title{Some Parametric Conditional Bivariate Copulas}
\usage{
dcopula.cond(u, v, copula, ...)

pcopula.cond(u, v, copula, ...)

qcopula.cond(p, v, copula, ...)

rcopula.cond(n, v, copula, ...)
}
\arguments{
\item{u}{vector of \eqn{U} values at which the copula density is evaluated}

\item{v}{a given value of \eqn{V} under which the conditional copula 
and its density is evaluated}

\item{copula}{the name of a copula density to be called (see Details)}

\item{...}{the parameter(s) of \code{copula}}

\item{p}{a vector of probabilities}

\item{n}{number of observations to be generated from conditional copula \eqn{C(u|V=v)}.}
}
\value{
a vector of copula density values evaluated at \code{u} gvien \code{V=v}
    or a vector of \code{n} generated \code{u} values from conditional copula \eqn{C(u|V=v)}.
}
\description{
Density, distribution function, quantile function and 
  random generation for conditional copula \eqn{C(u|V=v)} of \eqn{U} given \eqn{V=v}
   related to parametric bivariate copula \eqn{C(u,v)=P(U\le u, V\le v)}.
}
\details{
the names of available copulas are \code{'amh'} (Ali-Mikhai-Haq), \code{'bern'} (Bernstein polynomial model),
  \code{'clayton'}(Clayton), \code{'exponential'} (Exponential),  
  \code{'fgm'}(Farlie–Gumbel–Morgenstern),  \code{'frank'} (Frank), 
  \code{'gauss'} (Gaussian), \code{'gumbel'} (Gumbel), \code{'indep'} (Independence), 
  \code{'joe'} (Joe), \code{'nakagami'} (Nakagami-m), \code{'plackett'} (Plackett), 
  \code{'t'} (Student's t).
}
