% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R
\docType{class}
\name{saeObj-class}
\alias{saeObj-class}
\title{Small Area Estimation Objects}
\description{
Class for small area estimation, the one you're probably looking for.
}
\details{
\code{cluster} optionally gives the name of a variable in slot \code{data}
from which the cluster information for clustered sample designs is to be
read.
See Manadallaz 2013, p. 445 for Details.\cr
\code{include} optionally gives the name of a variable in slot \code{data}
from which the inclusion indicator for cluster points is to be read.
See Manadallaz 2013, p. 445 for Details on \eqn{I_f}.\cr
Also see the \bold{Details} for \code{\link{predict}}.
}
\section{Slots}{

\describe{
\item{\code{smallAreaMeans}}{An \emph{optional} \code{"data.frame"}
giving the true means of fixed effects for the small areas.
Must have a column with the random effect defining the small areas in
slot
\code{data}.}

\item{\code{s1}}{An \emph{optional} \code{"character"} string giving the name of a
variable in slot \code{data} indicating that an observation (a row in
slot
\code{data}) belongs to subset 1.}

\item{\code{s2}}{An \emph{optional} \code{"character"} string giving the name of a
variable in slot \code{data} indicating that an observation (a row in
slot
\code{data}) belongs to subset 2.}

\item{\code{data}}{Object of class \code{"data.frame"} to use for prediction,
typically
   consisting of a predictand and one or more predictors (zero or more fixed
   effects and one random effect defining the small areas).
   See \bold{Details} for optional clustering variable and/or inclusion
   indicator.}

\item{\code{f}}{Object of class \code{"formula"} a linear mixed effects model
formula.}

\item{\code{cluster}}{An \emph{optional} \code{"character"} string giving the name of
the
   clustering variable in slot \code{data}.}

\item{\code{include}}{An \emph{optional} \code{"character"} string giving the name of
the
   inclusion indicator in slot \code{data}.}

\item{\code{auxiliaryWeights}}{An \emph{optional} \code{"character"} string giving
the name of the
   auxiliary weights in slot \code{data}. You will need it, if your
   auxiliary
   data does not have full spatial support for each observation (for example
   when a shapefile does not completely cover all gird cells used to compute
   auxiliary data on).
   See
   \code{vignette("forestinventory_vignette", package = "forestinventory")}
   for details.}
}}

\section{Extends}{
 Class \code{"\linkS4class{savObj}"}, directly.
}

\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("saeObj", ...)} or via the constructor function
\code{"\link[=saObj]{?maSAE::saObj}"} (recommended).
}

\section{Methods}{
 \code{\link{predict}}
}

\examples{
showClass("saeObj")
}
\references{
\cite{
Mandallaz, D. 2013
Design-based properties of some small-area estimators in forest
inventory with two-phase sampling.
Canadian Journal of Forest Research \bold{43}(5), pp. 441--449.
doi: \href{http://dx.doi.org/10.1139/cjfr-2012-0381}{10.1139/cjfr-2012-0381}.
}
}
\seealso{
\code{"\link[stats:formula]{?stats::formula}"},
\code{"\link[=sadObj-class]{class?maSAE::saObj}"},
\code{"\link[=savObj-class]{class?maSAE::savObj}"},
\code{"\link[=saObj]{?maSAE::saObj}"} and
\code{"\link[=predict]{?maSAE::predict}"}

Other classes: 
\code{\link{characterOrNULL-class}},
\code{\link{sadObj-class}},
\code{\link{savObj-class}}
}
\concept{classes}
\keyword{classes}
