% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/execute-fetch-loop.R
\name{execute_fetch_loop}
\alias{execute_fetch_loop}
\title{Execution engine loop for all the fetch commands}
\usage{
execute_fetch_loop(
  self,
  msg_id,
  fetch_request,
  use_uid,
  write_to_disk,
  keep_in_mem,
  retries,
  fetch_type,
  base64_decode = FALSE
)
}
\arguments{
\item{self}{The R6 connection object.}

\item{msg_id}{A \code{numeric vector} containing one or more message ids.}

\item{fetch_request}{A string containing the fetch request to the server that
will be added to the curl handle.}

\item{use_uid}{Default is \code{FALSE}. In this case, results will be
presented as message's sequence numbers. A message sequence number is a
message's relative position to the oldest message in the mailbox. It may
change after deleting or moving messages. If a message is deleted,
sequence numbers are reordered to fill the gap. If \code{TRUE}, the
command will be performed using the \code{"UID"} or unique identifier,
and results are presented as such. UIDs are always the same during the
life cycle of a message.}

\item{write_to_disk}{If \code{TRUE}, writes the fetch content of each message
to a text file in a local folder inside the working directory, also
returning the results with \code{invisible()}. Default is \code{FALSE}.}

\item{keep_in_mem}{If \code{TRUE}, keeps a copy of each fetch result while
the operation is being performed with \code{write_to_disk = TRUE}. Default
is \code{FALSE}, and it can only be set \code{TRUE} when
\code{write_to_disk = TRUE}.}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{1}.}

\item{fetch_type}{A string indicating if it will be executed a body, header,
text, or metadata fetch.}

\item{base64_decode}{If \code{TRUE}, tries to guess and decode the fetched
text from base64 format to \code{character}. Default is \code{FALSE}. Only
used in the \code{fetch_text()} case.
@noRd}
}
\description{
Execution engine loop for all the fetch commands
}
