% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IS2.R
\name{IS_long2}
\alias{IS_long2}
\title{Interdaily Statbility for the Whole Dataset}
\usage{
IS_long2(count.data, window = 1, method = c("average", "sum"))
}
\arguments{
\item{count.data}{\code{data.frame} of dimension n * (1440+2) containing the
1440 dimensional activity data for all n subject days.
The first two columns have to be ID and Day. ID can be
either \code{character} or \code{numeric}. Day has to be \code{numeric} indicating
the sequency of days within each subject.}

\item{window}{an \code{integer} indicating what is the window to bin the data before
the function can be apply to the dataset. For details, see \code{bin_data}.}

\item{method}{\code{character} of "sum" or "average", function used to bin the data}
}
\value{
A \code{data.frame} with the following 2 columns
\item{ID}{ID}
\item{IS}{IS}
}
\description{
This function calcualte interdaily stability, a nonparametric metric
of circadian rhtymicity. This function is a whole dataset
wrapper for \code{IS}
}
\references{
Junrui Di et al. Joint and individual representation of domains of physical activity, sleep, and circadian rhythmicity. Statistics in Biosciences.
}
