% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lget.R
\name{lget}
\alias{lget}
\alias{lget.lvec}
\alias{lget.default}
\alias{lget.data.frame}
\title{Read elements from an lvec}
\usage{
lget(x, ...)

\method{lget}{lvec}(x, index = NULL, range = NULL, ...)

\method{lget}{default}(x, index = NULL, range = NULL, ...)

\method{lget}{data.frame}(x, index = NULL, range = NULL, ...)
}
\arguments{
\item{x}{the \code{\link{lvec}} to read from}

\item{...}{used to pass on additional arguments to other methods.}

\item{index}{a logical or numeric vector to index \code{x} with}

\item{range}{a numeric vector of length 2 specifying a range of elements 
to select. Specify either \code{index} or \code{range}.}
}
\value{
Returns an \code{\link{lvec}} with the selected elements. In order to convert
the selection to an R-vector \code{\link{as_rvec}} can e used.
}
\description{
Read elements from an lvec
}
\details{
Indexing using \code{index} should follow the same rules as indexing a regular
R-vector using a logical or numeric index. The range given by \code{range} 
includes both end elements. So, a range of \code{c(1,3)} selects the first 
three elements.
}
\examples{
a <- as_lvec(letters[1:4])
# Select first two elements
lget(a, 1:2)
lget(a, c(TRUE, TRUE, FALSE, FALSE))
lget(a, range = c(1,2))

# Logical indices are recycled: select odd elements
lget(a, c(TRUE, FALSE))

}
