% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lvec.R
\name{as_lvec}
\alias{as_lvec}
\title{Converts a primitive R-vector to lvec}
\usage{
as_lvec(x)
}
\arguments{
\item{x}{the object to convert. This can be a vector of type
\code{character}, \code{integer}, \code{numeric} or \code{logical}.}
}
\value{
Returns an \code{\link{lvec}} of the same type as \code{x}. When \code{x} is
already and \code{lvec}, \code{x} is returned. For character vectors the
maximum length of the \code{\link{lvec}} is set to the maximum length found
in \code{x}.
}
\description{
Converts a primitive R-vector to lvec
}
\examples{
# convert a character vector to lvec
x <- as_lvec(letters)
lget(x, 1:26)

}
