% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellwise.R
\docType{class}
\name{cellwise}
\alias{cellwise}
\title{The cellwise logger.}
\format{
An \code{R6} class object.
}
\usage{
cellwise(key, verbose=TRUE, tempfile=file.path(tempdir(),"cellwise.csv"))
}
\arguments{
\item{key}{\code{[character|integer]} index to column that uniquely identifies a row.}

\item{verbose}{\code{[logical]} toggle verbosity.}

\item{tempfile}{\code{[character]} filename for temporary log storage.}
}
\description{
The cellwise logger registers the row, column, old, and new value of cells
that changed, along with a step number, timestamp, source reference, and the
expression used to alter a dataset.
}
\section{Creating a logger}{

\code{cellwise$new(key, verbose=TRUE, file=tempfile())}
\tabular{ll}{
  \code{key}\tab \code{[character|integer]} index to column that uniquely identifies a row.\cr
  \code{verbose}\tab \code{[logical]} toggle verbosity.\cr
  \code{tempfile}\tab [character] filename for temporary log storage. \cr
}
}

\section{Dump options}{


\code{$dump(file=NULL)}
\tabular{ll}{
  \code{file}\tab \code{[character]} location to write final output to.\cr
}
The default location is \code{"cellwise.csv"} in an interactive session, and
\code{"DATA_cellwise.csv"} in a script that executed via \code{\link{run_file}}.
Here, \code{DATA} is the variable name of the data being tracked or the
\code{label} provided with \code{\link{start_log}}.
}

\section{Getting data from the logger}{


\code{$logdata()} Returns a data frame with the current log.
}

\section{Details}{

At initialization, the cellwise logger opens a connection to a temporary
file. All logging info is appended to that connection. When
\code{\link{dump_log}} is called, the temporary file is closed, copied to
the output file, and reopened for writing. The connection is closed
automatically when the logger is destroyed, for example when calling
\code{\link{stop_log}()}.
}

\examples{
logfile <- tempfile(fileext=".csv")

# convert height from inch to cm and log changes.
# we need to set a unique key.
women$sleutel <- 1:nrow(women)
out <- women \%L>\%
  start_log(log=cellwise$new(key="sleutel")) \%L>\%
  {.$height <- .$height*2.54; .} \%L>\%
  dump_log(file=logfile, stop=TRUE)

read.csv(logfile) \%L>\% head()

# work with an externally defined logger.
iris$id <- seq_len(nrow(iris))
logger <- cellwise$new(key="id")
iris \%L>\% 
  start_log(logger) \%L>\%
  head() \%L>\%
  stop_log(dump=FALSE)
logger$logdata()


}
\seealso{
Other loggers: 
\code{\link{expression_logger}},
\code{\link{filedump}},
\code{\link{simple}}
}
\concept{loggers}
