% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expression_logger.R
\docType{class}
\name{expression_logger}
\alias{expression_logger}
\title{The expression logger.}
\format{An \code{R6} class object.}
\usage{
expression_logger
}
\description{
Records the result of one or more user-defined expressions that perform
calculations on the object being tracked.
}
\section{Creating a logger}{
 
\code{expression_logger$new(..., verbose=TRUE)}
\tabular{ll}{
\code{...}\tab A comma-separated list of \code{name = expression} pairs. \cr
\code{verbose}\tab \code{[logical]} toggle verbosity.
}

Each expression will be evaluated in the context of the object tracked with
this logger. An expression is expected to have a single \code{numeric} or
\code{character} output.
}

\section{Dump options}{


\code{$dump(file=NULL)}
\tabular{ll}{
  \code{file}\tab \code{[character]} location to write final output to.\cr
}
The default location is \code{"expression.csv"} in an interactive session, and
\code{"DATA_expression.csv"} in a script that executed via \code{\link{run_file}}.
Here, \code{DATA} is the variable name of the data being tracked
or the \code{label} provided with \code{\link{start_log}}.
}

\examples{

logfile <- file.path(tempfile(fileext=".csv"))
e <- expression_logger$new(mean=mean(height), sd=sd(height))

out <- women \%L>\%
  start_log(e) \%L>\%
  within(height <- height * 2) \%L>\%
  within(height <- height * 3) \%L>\%
  dump_log(file=logfile)

read.csv(logfile)


}
\seealso{
Other loggers: \code{\link{cellwise}},
  \code{\link{filedump}}, \code{\link{simple}}
}
\concept{loggers}
\keyword{datasets}
