% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/c.PredictiveModelList.R
\name{c.PredictiveModelList}
\alias{c.PredictiveModelList}
\title{Merge PredictiveModelList objects}
\usage{
\method{c}{PredictiveModelList}(..., recursive = FALSE)
}
\arguments{
\item{...}{two or more PredictiveModelList objects}

\item{recursive}{for consistency with generic method (ignored)}
}
\value{
a PredictiveModelList object
}
\description{
Combine different PredictiveModelList objects into one
}
\examples{
\dontrun{

## Plum Island Ecosystems

## load data
data(pie)

## observed maps
obs <- ObsLulcRasterStack(x=pie,
                   pattern="lu",
                   categories=c(1,2,3),
                   labels=c("Forest","Built","Other"),
                   t=c(0,6,14))

## explanatory variables
ef <- ExpVarRasterList(x=pie, pattern="ef")

part <- partition(x=obs[[1]], size=0.1, spatial=TRUE)
train.data <- getPredictiveModelInputData(obs=obs, ef=ef, cells=part[["train"]], t=0)

forms <- list(Built ~ ef_001+ef_002+ef_003,
              Forest ~ 1,
              Other ~ ef_001+ef_002)

glm.models <- glmModels(formula=forms, family=binomial, data=train.data, obs=obs)
glm.models

## separate glm.models into two PredictiveModelList objects
mod1 <- glm.models[[1]]
mod2 <- glm.models[[2:3]]

## put them back together again
glm.models <- c(mod1, mod2)
glm.models

}
}

