% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ObsLulcRasterStack.R
\docType{methods}
\name{ObsLulcRasterStack}
\alias{ObsLulcRasterStack}
\alias{ObsLulcRasterStack,RasterLayer,ANY-method}
\alias{ObsLulcRasterStack,RasterStack,ANY-method}
\alias{ObsLulcRasterStack,character,character-method}
\alias{ObsLulcRasterStack,list,character-method}
\alias{ObsLulcRasterStack,missing,character-method}
\title{Create an ObsLulcRasterStack object}
\usage{
ObsLulcRasterStack(x, pattern, ...)

\S4method{ObsLulcRasterStack}{missing,character}(x, pattern, ...)

\S4method{ObsLulcRasterStack}{character,character}(x, pattern, ...)

\S4method{ObsLulcRasterStack}{list,character}(x, pattern, ...)

\S4method{ObsLulcRasterStack}{RasterLayer,ANY}(x, pattern, ...)

\S4method{ObsLulcRasterStack}{RasterStack,ANY}(x, pattern, categories, labels,
  t)
}
\arguments{
\item{x}{path (character), Raster* object or list of Raster* objects. Default
behaviour is to search for files in the working directory}

\item{pattern}{regular expression (character). Only filenames (if \code{x} is
a path) or Raster* objects (if \code{x} is a list) matching the regular
expression will be returned. See \cr
\code{raster::\link[raster]{raster}} for more information about supported filetypes}

\item{categories}{numeric vector of land use categories in observed maps}

\item{labels}{character vector (optional) with labels corresponding to
\code{categories}}

\item{t}{numeric vector containing the timestep of each observed map. The
first timestep must be 0}

\item{\dots}{additional arguments to \code{raster::\link[raster]{stack}}}
}
\value{
An ObsLulcRasterStack object.
}
\description{
Methods to create an ObsLulcRasterStack object, which may be created from file, an
existing Raster* object or a list of Raster* objects.
}
\details{
Observed land use maps should have the same extent and resolution. The
location of non-NA cells in \code{ObsLulcRasterStack} objects defines the region for
subsequent analysis.
}
\examples{
## Plum Island Ecosystems
obs <- ObsLulcRasterStack(x=pie,
                   pattern="lu",
                   categories=c(1,2,3),
                   labels=c("forest","built","other"),
                   t=c(0,6,14))

## Sibuyan Island
obs <- ObsLulcRasterStack(x=sibuyan$maps,
                   pattern="lu",
                   categories=c(1,2,3,4,5),
                   labels=c("forest","coconut","grass","rice","other"),
                   t=c(0,14))
}
\seealso{
\code{\link{ObsLulcRasterStack-class}}, \code{raster::\link[raster]{stack}}
}

