% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/subset.R
\docType{methods}
\name{subset,ExpVarRasterList-method}
\alias{subset,ExpVarRasterList-method}
\alias{subset,PerformanceList-method}
\alias{subset,PredictionList-method}
\alias{subset,PredictiveModelList-method}
\title{Subset}
\usage{
\S4method{subset}{ExpVarRasterList}(x, subset, ...)

\S4method{subset}{PredictiveModelList}(x, subset, ...)

\S4method{subset}{PerformanceList}(x, subset, ...)

\S4method{subset}{PredictionList}(x, subset, ...)
}
\arguments{
\item{x}{an object of class \code{ExpVarRasterList},
\code{PredictiveModelList}, \code{PredictionList} or \code{PerformanceList}}

\item{subset}{integer or character indicating the objects to be extracted}

\item{...}{additional arguments (none)}
}
\description{
Extract a subset of objects from container classes such as
\code{ExpVarRasterList}, \code{PredictiveModelList}, \code{PredictionList} and
\code{PerformanceList}.
}
\examples{
## Sibuyan Island

## load observed land use data
obs <- ObsLulcRasterStack(x=sibuyan$maps,
                    pattern="lu",
                    categories=c(1,2,3,4,5),
                    labels=c("Forest","Coconut","Grass","Rice","Other"),
                    t=c(0,14))

summary(obs)
obs <- subset(obs, subset=names(obs)[1])
summary(obs)

## load explanatory variables
ef <- ExpVarRasterList(x=sibuyan$maps, pattern="ef")

summary(ef)
ef <- subset(ef, subset=1:5)
summary(ef)
}

