## \code{$prefit()} initializes a lslxFitting object. ##
prelslx$set("public",
            "prefit",
            function(penalty_method = "mcp",
                     lambda_grid = "default",
                     delta_grid = "default",
                     step_grid = "default",
                     loss = "default",
                     algorithm = "default",
                     missing_method = "default",
                     start_method = "default",
                     lambda_direction = "default",
                     lambda_length = 50L,
                     delta_length = 3L,
                     threshold_value = 0.3,
                     subset = NULL,
                     cv_fold = 1L,
                     iter_out_max = 100L,
                     iter_in_max = 50L,
                     iter_other_max = 500L,
                     iter_armijo_max = 100L,
                     tol_out = 1e-3,
                     tol_in = 1e-3,
                     tol_other = 1e-7,
                     step_size = 0.5,
                     armijo = 1e-5,
                     ridge_cov = 0,
                     ridge_hessian = 1e-4,
                     ridge_weight = 1e-4,
                     warm_start = TRUE,
                     positive_variance = TRUE,
                     minimum_variance = 1e-4,
                     enforce_cd = TRUE,
                     weight_matrix = NULL,
                     verbose = TRUE) {
              control <-
                list(
                  penalty_method = penalty_method,
                  lambda_grid = lambda_grid,
                  delta_grid = delta_grid,
                  step_grid = step_grid,
                  loss = loss,
                  algorithm = algorithm,
                  missing_method = missing_method,
                  start_method = start_method,
                  lambda_direction = lambda_direction,
                  lambda_length = lambda_length,
                  delta_length = delta_length,
                  threshold_value = threshold_value,
                  subset = subset,
                  cv_fold = cv_fold,
                  iter_out_max = iter_out_max,
                  iter_in_max = iter_in_max,
                  iter_other_max = iter_other_max,
                  iter_armijo_max = iter_armijo_max,
                  tol_out = tol_out,
                  tol_in = tol_in,
                  tol_other = tol_other,
                  step_size = step_size,
                  armijo = armijo,
                  ridge_cov = ridge_cov,
                  ridge_hessian = ridge_hessian,
                  warm_start = warm_start,
                  positive_variance = positive_variance,
                  minimum_variance = minimum_variance,
                  enforce_cd = enforce_cd,
                  weight_matrix = weight_matrix
                )
              
              private$fitting <-
                lslxFitting$new(model = private$model,
                                data = private$data,
                                control = control)
            })
