% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic.lsirm.R
\name{diagnostic}
\alias{diagnostic}
\title{Diagnostic the result of LSIRM.}
\usage{
diagnostic(
  object,
  draw.item = list(beta = c(1), theta = c(1)),
  gelman.diag = FALSE
)
}
\arguments{
\item{object}{Object of class \code{lsirm}.}

\item{draw.item}{List; Each key in the list corresponds to a specific parameters such as "beta", "theta", "gamma", "alpha", "sigma", "sigma_sd", and "zw.dist". The values of the list indicate the indices of these parameters. For the key "zw.dist", the value is a matrix with two columns: the first column represents the indices of respondents, and the second column represents the indices of items.}

\item{gelman.diag}{Logical; If TRUE, the Gelman-Rubin convergence diagnostic will be printed. Default is FALSE.}
}
\value{
\code{diagnostic} returns plots for checking MCMC convergence for selected parameters.
}
\description{
\code{diagnostic} checks the convergence of MCMC for LSIRM parameters using various diagnostic tools, such as trace plots, posterior density distributions, autocorrelation functions (ACF), and Gelman-Rubin-Brooks plots.
}
\examples{
\donttest{
# Generate example item response matrix
data     <- matrix(rbinom(500, size = 1, prob = 0.5), ncol=10, nrow=50)

# For 1PL LSIRM
lsirm_result <- lsirm(data ~ lsirm1pl(spikenslab = FALSE, fixed_gamma = FALSE))
diagnostic(lsirm_result)

# For 2PL LSIRM
lsirm_result <- lsirm(data ~ lsirm2pl(spikenslab = FALSE, fixed_gamma = FALSE))
diagnostic(lsirm_result)

}
}
