% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/questionnaire_gen_family.R
\name{questionnaire_gen_family}
\alias{questionnaire_gen_family}
\title{Generation of ordinal and continuous variables}
\usage{
questionnaire_gen_family(
  n_obs,
  cat_prop,
  cov_matrix,
  family = "gaussian",
  theta = FALSE,
  mean_yx = NULL,
  n_cats
)
}
\arguments{
\item{n_obs}{number of observations to generate.}

\item{cat_prop}{list of cumulative proportions for each item.}

\item{cov_matrix}{covariance matrix. between the latent trait (Y) and the
background variables (X and Z).}

\item{family}{distribution of the background variables. Can be NULL or
'gaussian'.}

\item{theta}{if \code{TRUE} will label the first continuous variable 'theta'.}

\item{mean_yx}{vector with the means of the latent trait (Y) and the
continuous background variables with flexible variance (X).}

\item{n_cats}{vector with number of categories for each W.}
}
\description{
Creates a data frame of discrete and continuous variables based on a latent
correlation matrix and marginal proportions.
}
