% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lrsim}
\alias{lrsim}
\title{Log-rank test simulation}
\usage{
lrsim(
  kMax = NA_integer_,
  informationRates = NA_real_,
  criticalValues = NA_real_,
  futilityBounds = NA_real_,
  hazardRatioH0 = 1,
  allocation1 = 1L,
  allocation2 = 1L,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  piecewiseSurvivalTime = 0L,
  stratumFraction = 1L,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  gamma1 = 0L,
  gamma2 = 0L,
  accrualDuration = NA_real_,
  followupTime = NA_real_,
  fixedFollowup = 0L,
  rho1 = 0,
  rho2 = 0,
  plannedEvents = NA_integer_,
  plannedTime = NA_real_,
  maxNumberOfIterations = 1000L,
  maxNumberOfRawDatasetsPerStage = 0L,
  seed = NA_integer_
)
}
\arguments{
\item{kMax}{The maximum number of stages.}

\item{informationRates}{The information rates in terms of number
of events for the conventional log-rank test and in terms of
the actual information for weighted log-rank tests.
Fixed prior to the trial. If left unspecified, it defaults to
\code{plannedEvents / plannedEvents[kMax]} when \code{plannedEvents}
is provided and to \code{plannedTime / plannedTime[kMax]} otherwise.}

\item{criticalValues}{Upper boundaries on the z-test statistic scale
for stopping for efficacy.}

\item{futilityBounds}{Lower boundaries on the z-test statistic scale
for stopping for futility at stages 1, ..., \code{kMax-1}. Defaults to
\code{rep(-6, kMax-1)} if left unspecified.}

\item{hazardRatioH0}{Hazard ratio under the null hypothesis for the active
treatment versus control. Defaults to 1 for superiority test.}

\item{allocation1}{Number of subjects in the active treatment group in
a randomization block. Defaults to 1 for equal randomization.}

\item{allocation2}{Number of subjects in the control group in
a randomization block. Defaults to 1 for equal randomization.}

\item{accrualTime}{A vector that specifies the starting time of
piecewise Poisson enrollment time intervals. Must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities. One for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{stratumFraction}{A vector of stratum fractions that sum to 1.
Defaults to 1 for no stratification.}

\item{lambda1}{A vector of hazard rates for the event in each analysis
time interval by stratum for the active treatment group.}

\item{lambda2}{A vector of hazard rates for the event in each analysis
time interval by stratum for the control group.}

\item{gamma1}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the active treatment group.}

\item{gamma2}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the control group.}

\item{accrualDuration}{Duration of the enrollment period.}

\item{followupTime}{Follow-up time for the last enrolled subject.}

\item{fixedFollowup}{Whether a fixed follow-up design is used.
Defaults to 0 for variable follow-up.}

\item{rho1}{The first parameter of the Fleming-Harrington family of
weighted log-rank test. Defaults to 0 for conventional log-rank test.}

\item{rho2}{The second parameter of the Fleming-Harrington family of
weighted log-rank test. Defaults to 0 for conventional log-rank test.}

\item{plannedEvents}{The planned cumulative total number of events at
each stage.}

\item{plannedTime}{The calendar times for the analyses. To use calendar
time to plan the analyses, \code{plannedEvents} should be missing.}

\item{maxNumberOfIterations}{The number of simulation iterations.
Defaults to 1000.}

\item{maxNumberOfRawDatasetsPerStage}{The number of raw datasets per
stage to extract. Defaults to 1.}

\item{seed}{The seed to reproduce the simulation results.
The seed from the environment will be used if left unspecified,}
}
\value{
An S3 class \code{lrsim} object with 3 components:
\itemize{
\item \code{overview}: A list containing the following information:
\itemize{
\item \code{rejectPerStage}: The efficacy stopping probability by stage.
\item \code{futilityPerStage}: The futility stopping probability by
stage.
\item \code{cumulativeRejection}: Cumulative efficacy stopping
probability by stage.
\item \code{cumulativeFutility}: The cumulative futility stopping
probability by stage.
\item \code{numberOfEvents}: The average number of events by stage.
\item \code{numberOfDropouts}: The average number of dropouts by stage.
\item \code{numberOfSubjects}: The average number of subjects by stage.
\item \code{analysisTime}: The average analysis time by stage.
\item \code{overallReject}: The overall rejection probability.
\item \code{expectedNumberOfEvents}: The expected number of events for
the overall study.
\item \code{expectedNumberOfDropouts}: The expected number of dropouts
for the overall study.
\item \code{expectedNumberOfSubjects}: The expected number of subjects
for the overall study.
\item \code{expectedStudyDuration}: The expected study duration.
\item \code{hazardRatioH0}: Hazard ratio under the null hypothesis for
the active treatment versus control.
\item \code{useEvents}: whether the analyses are planned
based on the number of events or calendar time.
\item \code{accrualDuration}: Duration of the enrollment period.
\item \code{fixedFollowup}: Whether a fixed follow-up design is used.
\item \code{rho1}: The first parameter of the Fleming-Harrington family
of weighted log-rank test. Defaults to 0 for conventional log-rank
test.
\item \code{rho2}: The second parameter of the Fleming-Harrington family
of weighted log-rank test. Defaults to 0 for conventional log-rank
test.
\item \code{kMax}: The maximum number of stages.
}
\item \code{sumdata}: A data frame of summary data by iteration and stage:
\itemize{
\item \code{iterationNumber}: The iteration number.
\item \code{stopStage}: The stage at which the trial stops.
\item \code{eventsNotAchieved}: Whether the target number of events
is not achieved for the iteration.
\item \code{stageNumber}: The stage number, covering all stages even if
the trial stops at an interim look.
\item \code{analysisTime}: The time for the stage since trial start.
\item \code{accruals1}: The number of subjects enrolled at the stage for
the treatment group.
\item \code{accruals2}: The number of subjects enrolled at the stage for
the control group.
\item \code{totalAccruals}: The total number of subjects enrolled at
the stage.
\item \code{events1}: The number of events at the stage for
the treatment group.
\item \code{events2}: The number of events at the stage for
the control group.
\item \code{totalEvents}: The total number of events at the stage.
\item \code{dropouts1}: The number of dropouts at the stage for
the treatment group.
\item \code{dropouts2}: The number of dropouts at the stage for
the control group.
\item \code{totalDropouts}: The total number of dropouts at the stage.
\item \code{uscore}: The numerator of the log-rank test statistic.
\item \code{vscore}: The variance of the log-rank test statistic.
\item \code{logRankStatistic}: The log-rank test Z-statistic.
\item \code{rejectPerStage}: Whether to reject the null hypothesis
at the stage.
\item \code{futilityPerStage}: Whether to stop the trial for futility
at the stage.
}
\item \code{rawdata} (exists if \code{maxNumberOfRawDatasetsPerStage} is a
positive integer): A data frame for subject-level data for selected
replications, containing the following variables:
\itemize{
\item \code{iterationNumber}: The iteration number.
\item \code{stopStage}: The stage at which the trial stops.
\item \code{analysisTime}: The time for the stage since trial start.
\item \code{subjectId}: The subject ID.
\item \code{arrivalTime}: The enrollment time for the subject.
\item \code{stratum}: The stratum for the subject.
\item \code{treatmentGroup}: The treatment group (1 or 2) for the
subject.
\item \code{survivalTime}: The underlying survival time for the subject.
\item \code{dropoutTime}: The underlying dropout time for the subject.
\item \code{timeUnderObservation}: The time under observation
since randomization.
\item \code{event}: Whether the subject experienced the event.
\item \code{dropoutEvent}: Whether the subject dropped out.
}
}
}
\description{
Performs simulation for two-arm group sequential
trials based on weighted log-rank test.
}
\examples{
# Example 1: analyses based on number of events

sim1 = lrsim(kMax = 2, informationRates = c(0.5, 1),
             criticalValues = c(2.797, 1.977),
             accrualIntensity = 11,
             lambda1 = 0.018, lambda2 = 0.030,
             accrualDuration = 12,
             plannedEvents = c(60, 120),
             maxNumberOfIterations = 1000,
             maxNumberOfRawDatasetsPerStage = 1,
             seed = 314159)

# summary statistics
sim1

# summary for each simulated data set
head(sim1$sumdata)

# raw data for selected replication
head(sim1$rawdata)


# Example 2: analyses based on calendar time have similar power

sim2 = lrsim(kMax = 2, informationRates = c(0.5, 1),
             criticalValues = c(2.797, 1.977),
             accrualIntensity = 11,
             lambda1 = 0.018, lambda2 = 0.030,
             accrualDuration = 12,
             plannedTime = c(31.9, 113.2),
             maxNumberOfIterations = 1000,
             maxNumberOfRawDatasetsPerStage = 1,
             seed = 314159)

# summary statistics
sim2

# summary for each simulated data set
head(sim2$sumdata)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
