% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignProportions.R
\name{getDesignTwoMultinom}
\alias{getDesignTwoMultinom}
\title{Power and sample for difference in two-sample multinomial response}
\usage{
getDesignTwoMultinom(
  beta = NA_real_,
  n = NA_real_,
  ncats = NA_integer_,
  pi1 = NA_real_,
  pi2 = NA_real_,
  allocationRatioPlanned = 1,
  rounding = TRUE,
  alpha = 0.05
)
}
\arguments{
\item{beta}{The type II error.}

\item{n}{The total sample size.}

\item{ncats}{The number of categories of the multinomial response.}

\item{pi1}{The prevalence of each category for the treatment group.
Only need to specify the valued for the first \code{ncats-1} categories.}

\item{pi2}{The prevalence of each category for the control group.
Only need to specify the valued for the first \code{ncats-1} categories.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{rounding}{Whether to round up sample size. Defaults to 1 for
sample size rounding.}

\item{alpha}{The two-sided significance level. Defaults to 0.05.}
}
\value{
An S3 class \code{designTwoMultinom} object with the following
components:
\itemize{
\item \code{power}: The power to reject the null hypothesis.
\item \code{alpha}: The two-sided significance level.
\item \code{n}: The maximum number of subjects.
\item \code{ncats}: The number of categories of the multinomial response.
\item \code{pi1}: The prevalence of each category for the treatment group.
\item \code{pi2}: The prevalence of each category for the control group.
\item \code{effectsize}: The effect size for the chi-square test.
\item \code{calculationTarget}: The calculation target, \code{beta} or
\code{n}.
\item \code{allocationRatioPlanned}: Allocation ratio for the active treatment
versus control.
\item \code{rounding}: Whether to round up sample size.
}
}
\description{
Obtains the power given sample size or obtains the sample
size given power for difference in two-sample multinomial response.
}
\examples{

(design1 <- getDesignTwoMultinom(
  beta = 0.1, ncats = 3, pi1 = c(0.3, 0.35),
  pi2 = c(0.2, 0.3), alpha = 0.05))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
