% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{accrual}
\alias{accrual}
\title{Number of enrolled subjects}
\usage{
accrual(
  time = NA_real_,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  accrualDuration = NA_real_
)
}
\arguments{
\item{time}{A vector of calendar times at which to calculate the number
of enrolled subjects.}

\item{accrualTime}{A vector that specifies the starting time of
piecewise Poisson enrollment time intervals. Must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities. One for
each accrual time interval.}

\item{accrualDuration}{Duration of the enrollment period.}
}
\value{
A vector of total number of subjects enrolled by the
specified calendar times.
}
\description{
Obtains the number of subjects enrolled by given calendar
times.
}
\examples{
# Example 1: Uniform enrollment with 20 patients per month for 12 months.

accrual(time = 3, accrualTime = 0, accrualIntensity = 20,
        accrualDuration = 12)


# Example 2: Piecewise accrual, 10 patients per month for the first
# 3 months, and 20 patients per month thereafter. Patient recruitment
# ends at 12 months for the study.

accrual(time = c(2, 9), accrualTime = c(0, 3),
        accrualIntensity = c(10, 20), accrualDuration = 12)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
