% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{shilong}
\alias{shilong}
\title{The randomized clinical trial SHIVA data in long format from the
ipcwswitch package}
\format{
An object of class \code{data.frame} with 602 rows and 19 columns.
}
\usage{
shilong
}
\description{
The original SHIdat data set contains an anonymized excerpt of data from
the SHIVA01 trial. This was the first randomized clinical trial that
aimed at comparing molecularly targeted therapy based on tumor
profiling (MTA) versus conventional therapy (CT) for advanced cancer.
Patients were randomly assigned to receive the active or control
treatment and may switch to the other arm or subsequent anti-cancer
therapy upon disease progression.
The restructured data is in the long format.
\describe{
\item{\code{id}}{The patient's identifier}
\item{\code{tstart}}{The start of the time interval}
\item{\code{tstop}}{The end of the time interval}
\item{\code{event}}{Whether the patient died at the end of the interval}
\item{\code{agerand}}{The patient's age (in years) at randomization}
\item{\code{sex.f}}{The patients' gender, either Male or Female}
\item{\code{tt_Lnum}}{The number of previous lines of treatment}
\item{\code{rmh_alea.c}}{The Royal Marsden Hospital score segregated
into two categories}
\item{\code{pathway.f}}{The molecular pathway altered (the hormone
receptors pathway, the PI3K/ AKT/mTOR pathway, and the RAF/MEK pathway)}
\item{\code{bras.f}}{The patient's randomized arm, either MTA or CT}
\item{\code{ps}}{The ECOG performance status}
\item{\code{ttc}}{The presence of concomitant treatments}
\item{\code{tran}}{The use of platelet transfusions}
\item{\code{dpd}}{The relative day of a potential progression}
\item{\code{dco}}{The relative day of treatment switching}
\item{\code{ady}}{The relative day of the latest news}
\item{\code{dcut}}{The relative day of administrative cutoff}
\item{\code{pd}}{Whether the patient had disease progression}
\item{\code{co}}{Whether the patient switched treatment}
}
}
\keyword{datasets}
