% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rmst}
\alias{rmst}
\title{Restricted Mean Survival Time}
\usage{
rmst(t1 = 0, t2 = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_)
}
\arguments{
\item{t1}{Lower bound of the analysis time interval.}

\item{t2}{Upper bound of the analysis time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{lambda}{A vector of hazard rates for the event. One for
each analysis time interval.}
}
\value{
The integral of the survival function from \code{t1} to \code{t2}
}
\description{
Obtains the restricted mean survival time over an interval.
}
\examples{

rmst(t1 = 0, t2 = 7, piecewiseSurvivalTime = c(0, 6),
     lambda = c(0.0533, 0.0309))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
