% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull.R
\name{pull}
\alias{pull}
\alias{pull_}
\alias{pull_.data.frame}
\alias{pull_.list}
\alias{pull_.matrix}
\title{Column selection}
\usage{
pull(.data, j)

pull_(.data, j)

\method{pull_}{data.frame}(.data, j)

\method{pull_}{matrix}(.data, j)

\method{pull_}{list}(.data, j)
}
\arguments{
\item{.data}{A tbl.}

\item{j}{integer. The column to be extracted.}
}
\value{
A vector of length \code{nrow(.data)}
}
\description{
The function \code{pull} selects a column in a data frame
and transforms it into a vector.
This is useful to use it in combination with \pkg{magrittr}'s pipe operator
and \pkg{dplyr}'s verbs.
}
\examples{
library(dplyr)
mtcars[["mpg"]]
mtcars \%>\% pull(mpg)

# more convenient than (mtcars \%>\% filter(mpg > 20))[[3L]]
mtcars \%>\%
  filter(mpg > 20) \%>\%
  pull(3)

}
\author{
Adapted from Tommy O' Dell, 
see \url{http://stackoverflow.com/a/24730843/3902976} on StackOverflow.
}

