% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_which.R
\name{mutate_which}
\alias{mutate_which}
\alias{mutate_which_}
\alias{transmute_which}
\alias{transmute_which_}
\title{Add new variables or modify existing ones 
on a subset of the data}
\usage{
mutate_which(.data, .condition, ...)

mutate_which_(.data, .condition, ..., .dots)

transmute_which(.data, .condition, ...)

transmute_which_(.data, .condition, ..., .dots)
}
\arguments{
\item{.data}{A tbl or data.frame.}

\item{.condition}{A condition defining the subset on which the mutate 
or transmute operation applies. 
New variables are initialized to \code{NA}.}

\item{...}{Name-value pairs of expressions. Use \code{NULL} to drop a variable.}

\item{.dots}{Used to work around non-standard evaluation.}
}
\value{
A tbl or a data frame, depending on the class of \code{.data}.
}
\description{
The functions \code{mutate_which} and \code{transmute_which} are 
similar to \code{\link[dplyr]{mutate}} and \code{\link[dplyr]{transmute}} 
from package \pkg{dplyr}, except that they work only on a subset 
of \code{.data}, this subset being defined by the \code{.condition}. 

The functions \code{mutate_which_} and \code{transmute_which_} are 
standard evaluation versions, similar to \code{\link[dplyr]{mutate_}} and 
\code{\link[dplyr]{transmute_}}.
}
\examples{
df <- mtcars[1:10,]

# Non-standard evaluation
mutate_which(df, gear==4, carb = 100)
transmute_which(df, gear==4, carb = 100)

# Standard evaluation
mutate_which_(df, ~ gear==4, carb = ~ 100)
transmute_which_(df, ~ gear==4, carb = ~ 100)

}
\seealso{
\code{\link[dplyr]{mutate}},  
\code{\link[dplyr]{mutate_}}, 
\code{\link[dplyr]{transmute}},  
\code{\link[dplyr]{transmute_}} from package \pkg{dplyr}.
}
\author{
Adapted from G. Grothendieck on StackOverflow, see 
\url{http://stackoverflow.com/a/34096575}.
}
