% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpdensity.R
\name{lpdensity}
\alias{lpdensity}
\title{Local Polynomial Density Estimation and Inference}
\usage{
lpdensity(data, grid = c(), bw = c(), p = c(), q = c(), v = c(),
  bwselect = c("MSE", "IMSE", "ROT", "IROT"), kernel = c("triangular",
  "uniform", "epanechnikov"), Cweights = c(), Pweights = c(), scale = c())
}
\arguments{
\item{data}{Numeric vector or one dimensional matrix / data frame, the raw data.}

\item{grid}{Numeric vector or one dimensional matrix / data frame, the grid on which
density is estimated. When set to default, grid points will be chosen as 0.05-0.95
percentiles of the data, with 0.05 step size.}

\item{bw}{Numeric vector or one dimensional matrix / data frame, the bandwidth
used for estimation. Can be (1) a positive scalar (common
bandwidth for all grid points); or (2) a positive numeric vector specifying bandwidths for
each grid point (should be the same length as \code{grid}).}

\item{p}{Integer, the order of the local-polynomial used to construct point
estimates. Should be larger than 0. (Default is 2.)}

\item{q}{Integer, the order of the local-polynomial used to construct pointwise
confidence interval (a.k.a. the bias correction order). Default is \code{p+1}. When specified
\code{0}, no bias correction will be performed. Otherwise it should be larger than 2, and
strictly larger than \code{p}.}

\item{v}{Integer, the derivative to be estimated. Default is \code{1}, which is the density function.
Should be nonnegative.}

\item{bwselect}{String, the method for data-driven bandwidth selection. This option will be
ignored if \code{bw} is provided. Can be (1) \code{"MSE"} (default, mean squared error-optimal
bandwidth selected for each grid point); or (2) \code{"IMSE"} (integrated MSE-optimal bandwidth,
common for all grid points); (3) \code{"ROT"} (rule-of-thumb bandwidth with Gaussian
reference model); and (4) \code{"IROT"} (integrated rule-of-thumb bandwidth with Gaussian
reference model).}

\item{kernel}{String, the kernel function, should be one of \code{"triangular"}, \code{"uniform"} or
\code{"epanechnikov"}.}

\item{Cweights, }{Numeric vector or one dimensional matrix / data frame, the weights used
for counterfactual distribution construction. Should have the same length as sample size.}

\item{Pweights}{Numeric vector or one dimensional matrix / data frame, the weights used
in sampling. Should have the same length as sample size and nonnegative.}

\item{scale}{Numeric, scaling factor for the final estimate. This parameter controls how
estimates are scaled. For example, setting this parameter to 0.5 will scale down both the
point estimates and standard errors by half. By default it is 1. This parameter is used if only
part of the sample is used for estimation, and should not be confused with \code{Cweights}
or \code{Pweights}.}
}
\value{
\item{Estimate}{A matrix containing (1) \code{grid} (grid points), (2) \code{bw} (bandwidths), (3) \code{nh}
  (effective/local sample sizes), (4) \code{f_p} (point estimates with p-th order local polynomial),
  (5) \code{f_q} (point estimates with q-th order local polynomial, only if option \code{q} is nonzero),
  (6) \code{se_p} (standard error corresponding to \code{f_p}), and (7) \code{se_q} (standard error
  corresponding to \code{f_q}).}
\item{opt}{A list containing options passed to the function.}
}
\description{
\code{lpdensity} implements the local polynomial regression based density (and derivatives)
  estimator proposed in Cattaneo, Jansson and Ma (2017). This command can also be
  used to obtain smoothed estimates for cumulative distribution functions.
}
\details{
Companion command: \code{\link{lpbwdensity}} for data-driven bandwidth selection,
  and \code{\link{lpdensity.plot}} for density plot with robust confidence interval.
}
\examples{
set.seed(42); X <- rnorm(2000)
est1 <- lpdensity(data = X, bwselect = "IMSE")
summary(est1)

}
\references{
M. D. Cattaneo, M. Jansson and X. Ma. (2017). \href{http://www-personal.umich.edu/~cattaneo/papers/Cattaneo-Jansson-Ma_2017_LocPolDensity.pdf}{Simple Local Regression Distribution Estimators}. Working Paper, University of Michigan.
}
\seealso{
\code{\link{lpbwdensity}} and \code{\link{lpdensity.plot}}.
}
\author{
Matias D. Cattaneo, University of Michigan. \email{cattaneo@umich.edu}.

Michael Jansson, University of California, Berkeley. \email{mjansson@econ.berkeley.edu}.

Xinwei Ma (maintainer), University of Michigan. \email{xinweima@umich.edu}.
}
