% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimization_functions.R
\name{estimate_null_model}
\alias{estimate_null_model}
\title{Estimates the LoRI model under the constraint Theta = 0.}
\usage{
estimate_null_model(Y)
}
\arguments{
\item{Y}{A matrix of counts (contingency table).}
}
\value{
the null estimator under constraint Theta = 0
}
\description{
Estimates the LoRI model under the constraint Theta = 0.
}
\examples{
\dontshow{
X = matrix(rnorm(rep(0, 15)), 5)
Y <- matrix(rpois(length(c(X)), exp(c(X))), 5)
null_model <- estimate_null_model(Y)
}
}
