% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer.R
\name{l_layer.density}
\alias{l_layer.density}
\title{Layer Method for Kernel Density Estimation}
\usage{
\method{l_layer}{density}(widget, x, ...)
}
\arguments{
\item{widget}{widget path as a string or as an object handle}

\item{x}{object from \code{\link{density}} of class \code{"density"}}

\item{...}{additional arguments, often state definition for the basic
layering function}
}
\value{
layer object handle, layer id
}
\description{
Layer a line that represents a kernel density estimate.
}
\examples{
if(interactive()){

d <- density(faithful$eruptions, bw = "sj")
h <- l_hist(x = faithful$eruptions, yshows="density")
l <- l_layer.density(h, d, color="steelblue", linewidth=3)

}

}
\seealso{
\code{\link[stats]{density}}, \code{\link{l_layer}}
}
