% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_web.R
\name{l_web}
\alias{l_web}
\title{Open a browser with loon's R documentation webpage}
\usage{
l_web(page = "index", directory = c("home", "reference", "articles"), ...)
}
\arguments{
\item{page}{relative path to a page, the .html part may be omitted}

\item{directory}{if \code{"home"} then \code{page} is ignored and the
browser will open at the home page of the official loon documentation website at
  \url{http://great-northern-diver.github.io/loon/}.  If \code{page} refers to a \code{loon}
  manual reference, then directory must be \code{"reference"}; if \code{page} refers to the name
  of a vignette file, then directory should be \code{"articles"}}

\item{...}{arguments forwarded to browseURL, e.g. to specify a browser}
}
\description{
\code{l_web} opens a browser with the relevant page on the
  official loon documentation website at
  \url{http://great-northern-diver.github.io/loon/}.
}
\examples{

\dontrun{
l_web()
#
vignette("introduction", package = "loon")
# or
l_web(page = "introduction", directory = "articles")
#
help(l_hist)
l_web(page = "l_hist", directory = "reference")
}
}
\seealso{
\code{\link{l_help}},\code{\link{help}}, \code{\link{vignette}}
}
