% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_ColorList.R
\name{l_setColorList_hcl}
\alias{l_setColorList_hcl}
\title{Set loon's color mapping list to the colors from hcl color wheen}
\usage{
l_setColorList_hcl(chroma = 56, luminance = 51, hue_start = 231)
}
\arguments{
\item{chroma}{The chroma of the color. The upper bound for chroma depends on 
hue and luminance.}

\item{luminance}{A value in the range [0,100] giving the luminance of the 
colour. For a given combination of hue and chroma, only a subset of this 
range is possible.}

\item{hue_start}{The start hue for sampling. The hue of the color specified 
as an angle in the range [0,360]. 0 yields red, 120 yields green 240 yields
blue, etc.}
}
\description{
Loon's color list is used to map nominal values to colors. See
  the documentation for \code{\link{l_setColorList}}.
}
\details{
Samples equally distant colors from the hcl color wheel. See the
  documentation for \code{\link[grDevices]{hcl}} for more information.
}
\seealso{
\code{\link{l_setColorList}}, 
  \code{\link{l_setColorList_ColorBrewer}}, \code{\link{l_setColorList_hcl}},
  \code{\link{l_setColorList_baseR}}
}
