% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loon.shiny.R
\name{loon.shiny}
\alias{loon.shiny}
\title{Automatically Create a \code{shiny} App Based on Interactive \code{Loon} Widgets}
\usage{
loon.shiny(
  widgets,
  selectBy = c("byDefault", "brushing", "sweeping"),
  showWorldView = TRUE,
  plotRegionWidth = "500px",
  plotRegionHeight = "500px",
  plotRegionBackground = "gray92",
  layoutMatrix = NULL,
  nrow = NULL,
  ncol = NULL,
  widths = NULL,
  heights = NULL,
  displayedPanel = "",
  colorList = loon::l_getColorList(),
  inspectorLocation = c("auto", "auto", "60px", "20px"),
  inspectorWidth = "350px",
  inspectorHeight = "auto",
  options = list(),
  ...
)
}
\arguments{
\item{widgets}{A \code{loon} widget or a list of \code{loon} widgets.}

\item{selectBy}{The way to brush, can be 'brushing' (keep the brush whenever the plot is updated),
'sweeping' (clear the brush whenever the plot is updated) or 'byDefault' (determined by \code{loon} widget 'selectBy',
if 'selectBy' is sweeping, then \code{selectBy} will be assigned to 'sweeping', vice versa)}

\item{showWorldView}{Logical; whether to show the world view.}

\item{plotRegionWidth}{Plot region width. Must be a valid \code{CSS} unit (like '100%', '400px') or a number,
which will be coerced to a string and have 'px' appended. More details, check \code{\link{plotOutput}}.}

\item{plotRegionHeight}{Plot region height.}

\item{plotRegionBackground}{Plot region background color}

\item{layoutMatrix}{Optional layout matrix to place \code{loon} widgets. See \code{layout_matrix} in \code{\link{grid.arrange}}.}

\item{nrow}{Number of rows, see \code{\link{grid.arrange}}.}

\item{ncol}{Number of columns, see \code{\link{grid.arrange}}.}

\item{widths}{A unit vector giving the width of each plot.}

\item{heights}{A unit vector giving the height of each plot.}

\item{displayedPanel}{A string vector. The default is an empty string \code{""} so that
none inspector components (\code{Plot}, \code{Linking}, \code{Select}, etc) are open automatically.
The available strings are \code{c("Plot", "Select", "Linking", "Modify", "Layer", "Glyph")}}

\item{colorList}{A list of colors displayed on modify panel.}

\item{inspectorLocation}{A length four vector representing the distance between the
\code{bottom}, \code{left}, \code{top} and \code{right} of the inspector panel
and the \code{bottom}, \code{left}, \code{top} and \code{right} of the page or
parent container.}

\item{inspectorWidth}{Width of the inspector panel.}

\item{inspectorHeight}{Height of the inspector panel.}

\item{options}{\code{shinyApp} argument that should be passed to the \code{runApp} call, see \code{\link{shinyApp}}.}

\item{...}{Named arguments to modify shiny app.}
}
\value{
A \code{shiny.appobj} object that represents the \code{loon.shiny} app.
Printing the object or passing it to \code{\link{runApp}} will run the app.
}
\description{
Interactive \code{loon} widgets displayed in a \code{shiny} app
}
\details{
\itemize{
 \item{Useful hints for a \code{loon.shiny} app}
 {
 \itemize{
 \item{}{The inspector can be switched either by ``toggling tabpanel'' in the bar menu or
 the last mouse gesture input (\code{<double-click>}) on the plot region}
 \item{}{To downlight the selected elements, one has to double click on the plot region}
 \item{}{In \code{loon}, holding down the \code{<shift>} key while pressing the left button keeps the current selection states.
 In \code{loon.shiny} app, \code{<shift>} key is replaced by a `sticky` radiobutton. If the `sticky` mode is on,
 while sweeping, current selection states remain; else new selection will eliminate the previous selection states.}
 }
 }
 \item{Useful hints for a \code{loon.shiny} markdown file}{
 \itemize{
 \item{}{Based on our experience, setting `out.width` or `out.height` (try "10px") in the chunk could give a better layout}
 \item{}{To modify the app size, set `options = list(height = **, width = **)` in \code{loon.shiny()}}
 }
 }
}
}
\examples{
## Only run this example in interactive R sessions
if(interactive()) {
  ############### Basic ###############
  p <- l_plot(iris,
              color = iris$Species,
              showGuides = TRUE,
              showScales = TRUE)

  loon.shiny(p)

  ############### Link multiple plots ###############
  p1 <- l_plot(iris,
               linkingGroup = 'iris',
               showLabels = FALSE)
  p2 <- l_hist(iris$Sepal.Length,
               linkingGroup = 'iris',
               showLabels = FALSE,
               showStackedColors = TRUE)
  p3 <- l_hist(iris$Sepal.Width, linkingGroup = 'iris',
               color = iris$Species, sync = 'push',
               showLabels = FALSE, swapAxes = TRUE,
               showStackedColors = TRUE)
  loon.shiny(list(p1, p2, p3),
             layoutMatrix = matrix(c(2,NA,1,3),
             nrow = 2, byrow = TRUE))
}

\dontrun{
  if (requireNamespace('loon.ggplot', quietly = TRUE)) {
      p <- ggplot(mpg, aes(displ, hwy)) +
        geom_point(data = transform(mpg, class = NULL), colour = 'grey85') +
        geom_point() +
        facet_wrap(~class)
      g <- loon.ggplot(p, activeGeomLayers = 2) # active the second layer
      loon.shiny(g)
  }
}
}
