% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookout_ts.R
\name{lookout_ts}
\alias{lookout_ts}
\title{Identifies outliers in univariate time series using the algorithm lookout.}
\usage{
lookout_ts(x, alpha = 0.05)
}
\arguments{
\item{x}{The input univariate time series.}

\item{alpha}{The level of significance. Default is \code{0.05}.}
}
\value{
A lookout object.
}
\description{
This is the time series implementation of lookout.
}
\examples{
set.seed(1)
x <- arima.sim(list(order = c(1,1,0), ar = 0.8), n = 200)
x[50] <- x[50] + 10
plot(x)
lo <- lookout_ts(x)
lo
}
\seealso{
\code{\link{lookout}}
}
