% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_optimal.R
\name{lol.project.bayes_optimal}
\alias{lol.project.bayes_optimal}
\title{Bayes Optimal}
\usage{
lol.project.bayes_optimal(X, Y, mus, Sigmas, priors, ...)
}
\arguments{
\item{X}{\code{[n, p]} the data with \code{n} samples in \code{d} dimensions.}

\item{Y}{\code{[n]} the labels of the samples with \code{K} unique labels.}

\item{mus}{\code{[d, K]} the \code{K} class means in \code{d} dimensions.}

\item{Sigmas}{\code{[d, d, K]} the \code{K} class covariance matrices in \code{d} dimensions.}

\item{priors}{\code{[K]} the priors for each of the \code{K} classes.}

\item{...}{optional args.}
}
\value{
A list of class \code{embedding} containing the following:
\item{A}{\code{[d, r]} the projection matrix from \code{d} to \code{r} dimensions.}
\item{ylabs}{\code{[K]} vector containing the \code{K} unique, ordered class labels.}
\item{centroids}{\code{[K, d]} centroid matrix of the \code{K} unique, ordered classes in native \code{d} dimensions.}
\item{priors}{\code{[K]} vector containing the \code{K} prior probabilities for the unique, ordered classes.}
\item{Xr}{\code{[n, r]} the \code{n} data points in reduced dimensionality \code{r}.}
\item{cr}{\code{[K, r]} the \code{K} centroids in reduced dimensionality \code{r}.}
}
\description{
A function for recovering the Bayes Optimal Projection, which optimizes Bayes classification.
}
\examples{
library(lolR)
data <- lol.sims.rtrunk(n=200, d=30)  # 200 examples of 30 dimensions
X <- data$X; Y <- data$Y
# obtain bayes-optimal projection of the data
model <- lol.project.bayes_optimal(X=X, Y=Y, mus=data$mus,
                                   S=data$Sigmas, priors=data$priors)
}
\author{
Eric Bridgeford
}
