% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-approved.R
\name{build_approved}
\alias{build_approved}
\title{Build approved packages and functions tibble}
\usage{
build_approved(pkg_list, file = NULL)
}
\arguments{
\item{pkg_list}{Named list of character vectors:
\itemize{
\item Name is the package name
\item Value is a character vector of approved functions or 'All'
}}

\item{file}{String. Name of file where the approved tibble will be written
to. If not specified, the tibble is returned

Default: NULL

Permitted Files: .RDS}
}
\value{
Tibble with two columns (library, function) and one row per function
}
\description{
A utility function to help you build your approved packages and functions
list. This can be used by logrx to log unapproved use of packages and
functions.
}
\details{
For more details see the vignette:
\code{vignette("approved", package = "logrx")}
}
\examples{
approved_pkgs <- list(
  base = c("library", "mean"),
  dplyr = "All"
)

# build and return
build_approved(approved_pkgs)

# build and save
dir <- tempdir()
build_approved(approved_pkgs, file.path(dir, "approved.rds"))

}
