% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/logisticPCA.R
\name{cv.lpca}
\alias{cv.lpca}
\title{CV for logistic PCA}
\usage{
cv.lpca(x, ks, Ms = seq(2, 10, by = 2), folds = 5, quiet = TRUE, ...)
}
\arguments{
\item{x}{matrix with all binary entries}

\item{ks}{the different dimensions \code{k} to try}

\item{Ms}{the different approximations to the saturated model \code{M} to try}

\item{folds}{if \code{folds} is a scalar, then it is the number of folds. If
it is a vector, it should be the same length as the number of rows in \code{x}}

\item{quiet}{logical; whether the function should display progress}

\item{...}{Additional arguments passed to \code{logisticPCA}}
}
\value{
A matrix of the CV negative log likelihood with \code{k} in rows and
 \code{M} in columns
}
\description{
Run cross validation on dimension and \code{M} for logistic PCA
}
\examples{
# construct a low rank matrix in the logit scale
rows = 100
cols = 10
set.seed(1)
mat_logit = outer(rnorm(rows), rnorm(cols))

# generate a binary matrix
mat = (matrix(runif(rows * cols), rows, cols) <= inv.logit.mat(mat_logit)) * 1.0

\dontrun{
negloglikes = cv.lpca(mat, ks = 1:9, Ms = 3:6)
plot(negloglikes)
}
}

