% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logic.boosting.R
\name{importance.test.boosting}
\alias{importance.test.boosting}
\title{Term importance test based on boosted linear models}
\usage{
importance.test.boosting(model, X, y, Z, Z.interactions = TRUE)
}
\arguments{
\item{model}{A fitted \code{linear.logic} model (i.e., a model created via
\code{\link{fitLinearLogicModel}} or \code{\link{fitLinearBoostingModel}})}

\item{X}{Matrix or data frame of binary input data.
This object should correspond to the binary matrix for fitting the model.}

\item{y}{Response vector. 0-1 coding for binary outcomes.}

\item{Z}{Optional quantitative covariables supplied as a matrix or
data frame. Only used (and required) if the model was fitted using them.}

\item{Z.interactions}{A Boolean value determining whether interactions with
quantitative covaraible \code{Z} shall be taken into account}
}
\value{
A data frame consisting of three columns,
  \item{\code{var}}{The tested term,}
  \item{\code{vim}}{The associated variable importance, and}
  \item{\code{p.value}}{The corresponding p-value for testing if the term
    is influential.}
}
\description{
This function takes a fitted \code{linear.logic} model and independent test
data as input for testing if the included terms are influential with respect
to the outcome.
This hypothesis test is based on a likelihood-ratio test.
}
\details{
In detail, the null hypotheses
\deqn{H_0: \beta_j = \delta_j = 0}
using the linear model
\deqn{g(E[Y]) = \beta_0 + \sum_{i=1}^B \beta_i \cdot 1[C_i] + \delta_0 \cdot E
+ \sum_{i=1}^B \delta_i \cdot 1[C_i] \cdot E}
are tested for each \eqn{j \in \lbrace 1,\ldots,B \rbrace}
if \code{Z.interactions} is set to \code{TRUE}.
Otherwise, the null hypotheses
\deqn{H_0: \beta_j = 0}
using the linear model
\deqn{g(E[Y]) = \beta_0 + \sum_{i=1}^B \beta_i \cdot 1[C_i] + \delta_0 \cdot E}
are tested.
}
