% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excursion.R
\name{proba_theoretical_ith_excursion_markov}
\alias{proba_theoretical_ith_excursion_markov}
\title{theoretical probability of reaching the threshold score a on the i-th excursion (sequential order) of a markov's score sequence}
\usage{
proba_theoretical_ith_excursion_markov(
  a,
  theta,
  lambda,
  score_function,
  i,
  prob0 = NULL,
  epsilon = 1e-16
)
}
\arguments{
\item{a}{threshold score}

\item{theta}{vector containing the alphabet used}

\item{lambda}{transition probability matrix of the markov chain, square, same size and order as theta}

\item{score_function}{vector containing the scores of each letters of the alphabet (must be in the same order as theta)}

\item{i}{number of wanted excursion (sequential order)}

\item{prob0}{probability distribution of the first letter of the sequence (stationary distribution of lambda if the parameter is NULL),
used only for computation of proba_q_i_geq_a}

\item{epsilon}{threshold for the computation of matrix M: to calculate the probabilities, this function need to compute the matrix M (transition probability matrix of the beginning of excursions, as in the paper)
with a recurrence, this recurrence stop at a certain number of iterations or when the maximal absolute value of the difference between an iteration and the next one is < epsilon.}
}
\value{
a list containing:\tabular{ll}{
    \code{proba_q_i_geq_a} \tab reel number between 0 and 1 representing the theoretical probability that the i-th excursion is greater or equal a \cr
    \tab \cr
    \code{P_alpha} \tab vector containing the probabilities (of reaching the threshold score on the i-th excursion) depending on the first letter of the sequence (alpha) \cr
}
}
\description{
This function implements the results of the paper: "Exact distribution of excursion heights of the Lindley process in a Markovian model", this is an
exact method. 
Scores of score function have to be integers, the expectancy of the score have to be negative, the score function have to contains at least
one positive integer, i have to be >0
}
\details{
Be careful: the computational time is exponential in function of the maximum score of the score function.
The computational time also increase with the rise of the threshold score a and with the lowering of the minimum of the score function and have a cubic complexity in function of the size of theta.
Lowering epsilon can also decrease the execution time of the function but it can have an impact on the accuracy of the probabilities.
}
\examples{
## In this example: the probability to reach a score of a in the third excursion is: 0.04237269
## The conditional probabilities to reach a score of a in the third excursion if the first
## letter of the sequence is K, L or M are respectively: 0.04239004, 0.04247805 and 0.04222251
proba_theoretical_ith_excursion_markov(a = 5,
               theta = c("K","L","M"),
               lambda = matrix(c(0.5, 0.3, 0.2,
                                 0.4, 0.2, 0.4,
                                 0.4, 0.4, 0.2), 
                               ncol = 3, byrow = TRUE),
               score_function = c(-2,-1,2),
               i = 3,
               prob0 = c(0.4444444, 0.2962963, 0.2592593))
### This example implements the numerical application of the paper,
###    the global probability is 0.2095639
proba_theoretical_ith_excursion_markov(a = 6,
            theta = c("a","b","c","d","e"),
            lambda = matrix(c(0.1, 0.7, 0.05, 0.05, 0.1,
                              0.3, 0.3, 0.2, 0.15, 0.05,
                              0.1, 0.4, 0.15, 0.2, 0.15,
                              0.5, 0.05, 0.25, 0.1, 0.1,
                              0.25, 0.05, 0.5, 0.15, 0.05),
                              ncol = 5,nrow=5, byrow = TRUE),
            score_function = c(-3,-2,-1,6,7),
            i = 3)
}
