% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMethods.R
\name{RealScores2IntegerScores}
\alias{RealScores2IntegerScores}
\title{Convert a real scores vector into an integer scores vector}
\usage{
RealScores2IntegerScores(RealScore, ProbRealScore, coef = 10)
}
\arguments{
\item{RealScore}{vector of real scores}

\item{ProbRealScore}{vector of probability}

\item{coef}{coefficient}
}
\value{
list containing ExtendedIntegerScore and ProbExtendedIntegerScore
}
\description{
Convert real scores into integer scores
}
\details{
Convert real scores into integer scores by multiplying real
scores by a coefficient (default 10) and then assigning probability to corresponding
extended (from the minimum to the maximum) integer scores
}
\examples{
score <- c(-1,-0.5,0,0.5,1)
prob.score <- c(0.2,0,0.4,0.1,0.3)
(res1 <- RealScores2IntegerScores(score, prob.score, coef=10))
prob.score.err <- c(0.1,0,0.4,0.1,0.3)
(res2 <- RealScores2IntegerScores(score, prob.score.err, coef=10))
# When coef=1, the function can handle integer scores
ex.integer.score <- c(-3,-1,0,1, 5)
(res3 <- RealScores2IntegerScores(ex.integer.score, prob.score, coef=1))
}
