% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernels.R
\name{gaussian_kernel}
\alias{gaussian_kernel}
\title{LIME kernel from the original article with sigma = 1.}
\usage{
gaussian_kernel(explained_instance, simulated_instance)
}
\arguments{
\item{explained_instance}{explained instance}

\item{simulated_instance}{new observation}
}
\value{
numeric
}
\description{
Since only binary features are used, the weight associated with an observation
is simply exp(-\{number of features that were changed compared to the original observation\}).
Kernels are meant to be used as an argument to individual_surrogate_model function.
Other custom functions can be used. Such functions take two vectors and
return a single number.
}
\examples{
library(DALEX)
library(randomForest)
library(localModel)
data('apartments')
mrf <- randomForest(m2.price ~., data = apartments, ntree = 50)
explainer <- explain(model = mrf,
                     data = apartments[, -1])
model_lok <- individual_surrogate_model(explainer, apartments[5, -1],
                                        size = 500, seed = 17,
                                        kernel = gaussian_kernel)
# In this case each simulated observation has weight
# that is small when the distance from original observation is large,
# so closer observation have more weight.
model_lok
plot(model_lok)

}
