% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{mprte}
\alias{mprte}
\title{Estimation of Marginal Policy Relevant Treatment Effects (MPRTE)}
\usage{
mprte(mte_fit, policy)
}
\arguments{
\item{mte_fit}{An object of class \code{mte} returned by \code{\link{mte}}.}

\item{policy}{A univariate scalar function that measures the intensity
of policy intervention across individuals with different levels of
the propensity score.}
}
\value{
Estimate of MPRTE.
}
\description{
\code{mprte} is a function that estimates a class of marginal policy relevant
treatment effects (MPRTE) considered in Zhou and Xie (2018). The user needs to
specify a \code{policy} as a scalar function of the propensity score.
}
\examples{
mte_fit <- mte(selection = d ~ x + z, outcome = y ~ x,
  method = "localIV", data = toydata)

mprte1 <- mprte(mte_fit, policy = function(p) 1)
mprte2 <- mprte(mte_fit, policy = function(p) p)
mprte3 <- mprte(mte_fit, policy = function(p) I(p<0.2))
c(mprte1, mprte2, mprte3)

}
\references{
Zhou, Xiang and Yu Xie. Forthcoming. "Marginal Treatment Effects from
  A Propensity Score Perspective." Journal of Political Economy.
}
