% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/address.R
\name{obj_addr}
\alias{obj_addr}
\alias{obj_addrs}
\title{Find memory location of objects and their children.}
\usage{
obj_addr(x)

obj_addrs(x)
}
\arguments{
\item{x}{An object}
}
\description{
\code{obj_addr()} gives the address of the value that \code{x} points to;
\code{obj_addrs()} gives the address of the components the list,
environment, and character vector \code{x} point to
}
\examples{
# R creates copies lazily
x <- 1:10
y <- x
obj_addr(x) == obj_addr(y)

y[1] <- 2L
obj_addr(x) == obj_addr(y)

y <- runif(10)
obj_addr(y)
z <- list(y, y)
obj_addrs(z)

y[2] <- 1.0
obj_addrs(z)
obj_addr(y)

# The address of an object is different every time you create it:
obj_addr(1:10)
obj_addr(1:10)
obj_addr(1:10)
}
