% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadr.R
\name{vload}
\alias{vload}
\title{Loads R objects into the shared variable environment.}
\usage{
vload(..., varNames = NULL)
}
\arguments{
\item{...}{Any number of variables to assign to the shared variable environment}

\item{varNames}{(Optional) character vector of variable names to use for the
given variables. If provided, the length of varNames must match the number
of variables passed to ....}
}
\description{
This function loads one or more R objects into the shared variable
environment. By default it will assign variable names as they are named when
passed to the function, but it can also assign variables to alternative names
using the varNames argument.
}
\examples{
x=5; y=7; z=15
vload(x, y, z)
vload(c(1,2,3), varNames="varname")
vload(x, y, varNames=c("xvar", "yvar"))
}
